;;; -*- Mode:Common-Lisp; Package:EH; Base:8; Fonts:(CPTFONT HL10B HL12BI HL12B CPTFONTB)1; *Patch-File:T -*-

;1;;                     RESTRICTED RIGHTS LEGEND          *
;1;; Use, duplication, or disclosure by the Government is subject to*
;1;; restrictions as set forth in subdivision (b)(3)(ii) of the Rights in*
;1;; Technical Data and Computer Software clause at 52.227-7013.*
;1;;                   TEXAS INSTRUMENTS INCORPORATED.*
;1;;                            P.O. BOX 149149*
;1;;                         AUSTIN, TEXAS 78714-9149*
;1;;                             MS 2151*
;1;; Copyright (C) 1986,1987 Texas Instruments Incorporated. All rights reserved.*
;1;; Copyright (C) 1984-1989 Texas Instruments Incorporated. All rights reserved.*
;1;; ** (c) Copyright 1980 Massachusetts Institute of Technology ***

;;;Record of changes
;;;1-----------------------------------------------------------------------------------------------*
;;;     WHEN   WHO 1   *PATCH   1     *WHAT
;;;  11-15-88   LG    5-03	:KILL a window debugger when ENDed rather than :DEACTIVATE.
;;;  07-11-88 1  *clm for may  	Modified COMW-ARGLIST to look at BOTH values catch-error returns.
;;; 1  *4/6/89    jlm   	1             *changed reference to PACKAGE to *PACKAGE* in 
;;;      1                                      *(DEFMETHOD (DEBUGGER-FRAME :AROUND :FETCH-AND-EXECUTE)
;1--------------------------------------------------------------------------------------------------*

(DEFVAR 4*numeric-arg** 1 
  "2The numeric argument passed to the commands*")

(DEFFLAVOR 4debugger-who-line-mixin* 
           ((normal-mouse-doc '(:mouse-l-1 "3Inspect selected object.*"
                                :mouse-m-1 "3Set * to object; Echo object in interaction pane.*")))
           ()
  (:documentation :combination "3A flavor to mix into debugger panes to get who line documentation.*"))

(DEFMETHOD 4(debugger-who-line-mixin :who-line-documentation-string*) ()
  "2Who line documentation for the stack, args, locals, history and inspection panes.*"
  (LET*
    ((frame (SEND self :superior)) (interactor (SEND frame :get-pane 'lisp-window)))
    (OR (SEND frame :who-line-doc-string-overide)
	(IF (SEND frame :doing-typein-p)
	    (SEND interactor :who-line-documentation-string)
	    (MULTIPLE-VALUE-BIND (x y) ;1; get mouse position*
		(tv:sheet-calculate-offsets self tv:mouse-sheet)
	      (SETQ x (- system:mouse-x x)
		    y (- system:mouse-y y))
	      (MULTIPLE-VALUE-BIND (item item-type)
		  (SEND self :mouse-sensitive-item x y)
		(COND ((NOT (OR item item-type))
		       '(:mouse-r-1 "3Menu of all window-based debugger commands*"))
		      (t
                       normal-mouse-doc))))))))

(DEFMETHOD 4(debugger-who-line-mixin :line-area-mouse-documentation*) ()
  "2Line area documentation for the history and stack pane.*"
  (OR (SEND (SEND self :superior) :who-line-doc-string-overide)
      (IF (TYPEP self 'debugger-history-pane)
          normal-mouse-doc
          '(:mouse-any "3Select the stack frame the mouse is pointing at.*"))))

(DEFFLAVOR 4debugger-lisp-listener-pane*
           nil
           (ucl::command-and-lisp-typein-window tv:interaction-pane)
           (:documentation :combination
                           "3The read-eval-print window in the window-based debugger*"))
 
(DEFMETHOD 4(debugger-lisp-listener-pane :around :who-line-documentation-string*)
 (cont mt ignore)
 "2Check for who line documentation overide done by commands.*"
 (OR (SEND (SEND self :superior) :who-line-doc-string-overide)
     (IF (SEND (SEND self :superior) :doing-typein-p)
         (FUNCALL-WITH-MAPPING-TABLE cont mt :who-line-documentation-string)
         '(:mouse-r-1 "3Menu of all window-based debugger commands*"))))

(DEFFLAVOR 4debugger-text-scroll-pane*
           nil
           (tv:function-text-scroll-window tv:mouse-sensitive-text-scroll-window
                                           ;1TV:FLASHY-SCROLLING-MIXIN*
                                           tv:stream-mixin
                                           tv:select-mixin
                                           tv:borders-mixin
                                           tv:top-label-mixin
                                           w:scroll-bar-mixin
                                           ;1TV:BASIC-SCROLL-BAR*
                                           ;1TV::MARGIN-SCROLLING-WITH-FLASHY-SCROLLING-MIXIN*
                                           ;1TV:MARGIN-SCROLL-MIXIN*
                                           tv:margin-region-mixin
                                           ;1TV:MOUSE-SENSITIVE-TEXT-SCROLL-WINDOW*
                                           tv:delay-notification-mixin
                                           w:graphics-mixin 
                                           w:minimum-window)
           (:default-init-plist
             :scroll-bar-draw-edge-p t)
           (:documentation :combination "3Scroll windows for the window-based debugger*"))

(DEFFLAVOR 4gray-debugger-text-scroll-pane*
           nil
           (debugger-who-line-mixin tv:text-scroll-window-empty-gray-hack
                                    debugger-text-scroll-pane)
           (:documentation :combination "3Args window in window-based debugger*"))

(DEFFLAVOR 4gray-debugger-thermometer-text-scroll-pane*
           nil
           (debugger-who-line-mixin
	    ;1TV:BASIC-SCROLL-BAR      ;replaced by w:scroll-bar-mixin in parent flavor*
	    gray-debugger-text-scroll-pane)
           (:documentation :combination "3Locals window in window-based debugger*"))

(DEFFLAVOR 4stack-scroll-pane*
           ((*print-length* *error-print-length*) (*print-level* *error-print-level*))
           (debugger-who-line-mixin tv:current-item-mixin
                                    ;1TV:FLASHY-MARGIN-SCROLLING-MIXIN*
                                    ;1TV:FUNCTION-TEXT-SCROLL-WINDOW*
                                    tv:line-area-mouse-sensitive-text-scroll-mixin
                                    ;1TV:MOUSE-SENSITIVE-TEXT-SCROLL-WINDOW*
                                    ;1TV:MARGIN-REGION-MIXIN*
                                    debugger-text-scroll-pane)
           :special-instance-variables
           (:documentation :combination "3Stack window in the window-based debugger*"))

;1 TAC 08-04-89 - this flavor is redefined later in GENERAL-INSPECT-DEBUGGER *
;1                  it requires some things that are not defined until GENERAL-INSPECTOR is defined.*
(DEFFLAVOR 4debugger-history-pane*
           nil
           (debugger-who-line-mixin tv::inspect-history-window))  ;1-PANE-WITH-MARGIN-SCROLLING))*

(DEFFLAVOR 4debugger-inspect-pane* nil (debugger-who-line-mixin tv::inspect-pane))

(DEFFLAVOR 4debugger-menu-pane*
           nil
           (w:menu)
           (:default-init-plist
	     :scrolling-p nil
	     :command-menu t
	     :dynamic t)
           (:documentation :combination "3UCL menus need dynamic item list mixin.*"))

;1; This needs to go in the Error Handler so Leaving-Error-Handler can use it also.*
(DEFUN 4more-window-debuggers-p* ()
  (DOLIST (x (tv::selectable-windows tv:mouse-sheet))
    (WHEN (TYPEP (SECOND x) 'debugger-frame) (RETURN t))))

(DEFVAR 4*window-debugger** nil "2Bound in error handler stack group to the current window-based debugger frame.*")
;1(DEFVAR *ERROR-SG* NIL "The erring stack group.")*
;1(DEFVAR *ERROR-OBJECT* NIL "The error object for this erring stack group.")*

;1; This function is necessary because when you abort out of the w-d, it throws out of the stack-group, which*
;1; avoids doing the clean-up forms of unwind-protect and the like. Without this the selection substitutes never*
;1; get reset and everything's screwed up. Also the w-d will hang around on the system menu and system keys.*
(DEFUN 4clean-up-window-debugger* ()
  "2This will clean up after the window-debugger. If it is the only existing window-debugger, it will
 remove it from the system menu and the system keys. It also resets the selection substitutes.*"
  (UNLESS (more-window-debuggers-p)
    (tv:remove-system-key (CHAR-INT #\W))
    (tv::delete-from-system-menu-column :debug "3Debugger*"))
  (LET ((tv-cur-win (SEND *window-debugger* :tv-current-window))
        (tv-old-sub (SEND *window-debugger* :tv-old-subst)))
  (tv:delaying-screen-management (WHEN tv-cur-win
                                       (SEND tv-cur-win :set-selection-substitute tv-old-sub))
                                     (LET ((tv::.flag. (tv:sheet-me-or-my-kid-p tv:selected-window
                                                                                *window-debugger*)))
                                       (SEND *window-debugger* :kill)
                                       (AND tv-cur-win
                                            tv::.flag.
                                            (SEND tv-cur-win :select nil))))))

;1; This function is how the regular debugger enters the window-based debugger.*
(DEFUN 4com-window-debugger* (sg ete) 
  "2Use a window-based debugger to debug the stack.*"
  (IF (EQ *terminal-io* sys:cold-load-stream) ;1; sys: is temp*
   (FORMAT t
    "3~&The window-based debugger cannot be invoked since we are using the cold load stream.*")
   (tv:remove-system-key (CHAR-INT #\W))
   (tv:add-system-key (CHAR-INT #\W) 'debugger-frame
                      "3Window-based Debugger - debug a program with menus and mouse interaction.*"
                      nil)
   (tv::delete-from-system-menu-column :debug "3Debugger*")	;1; In case one is already out there*
   (tv::add-to-system-menu-column :debug "3Debugger*"
     '(LET ((w (tv:find-window-of-flavor 'debugger-frame)))
        (COND (w
               (SEND w :select)
               (SEND w :update-print-info))   ;1!*
              (t (BEEP))))
     "3Select a Window-based Debugger Frame.*")
;1!   (tv:set-print-info)      ;Make sure *inspect-print-base*, etc. is correct*
   (USING-RESOURCE (window debugger-frame tv:default-screen)
     (SEND window :set-sensitive-item-types '(:value :function stack-frame))
     (UNWIND-PROTECT 
	 (window-command-loop sg ete window)
       (UNLESS (more-window-debuggers-p)
    (tv:remove-system-key (CHAR-INT #\W))
    (tv::delete-from-system-menu-column :debug "3Debugger*"))))))

;1; The following code can be removed when the regular debugger's code*
;1; is updated to use "*window-debugger*" instead of error-handler-window,*
;1; and "com-window-debugger" replaces "com-window-error-handler".*
;1(DEFVAR ERROR-HANDLER-WINDOW)*
;1(FORWARD-VALUE-CELL 'ERROR-HANDLER-WINDOW '*WINDOW-DEBUGGER*)*
;1(DEFF COM-WINDOW-ERROR-HANDLER 'COM-WINDOW-DEBUGGER)*

;1; change SYS:DEBUG-UTILITIES;WINDOW-DEBUG.LISP#205 to not use AP but FRAME *
;1; and to reference args and locals in reg pdl correctly*

(DEFUN 4window-command-loop* (*error-sg* *error-object* *window-debugger*)
  "2This function calls the UCL command loop.*"
  (LET ((*evalhook* nil)
        (*nopoint nil)
	(*print-pretty* nil)
	(*print-array*  *print-array*)     ;1!*
	(*print-circle* *print-circle*)    ;1!*
	(*print-radix*  *print-radix*)     ;1!*
	(*print-base*   *print-base*)      ;1!*
	(*read-base*    *read-base*)       ;1!*
	(*print-level*  *print-level*)     ;1!*
	(*print-length* *print-length*)    ;1!*
        (*package* *package*)   
        (*window-debugger-old-window* t)
        (*terminal-io* (SEND *window-debugger* :lisp-window))
	(ucl::*default-top-level-function-execute-specials* '(*terminal-io*))
	(ucl::*default-top-level-symbols-execute-specials* '(*terminal-io*))
	(ucl::top-level-self (SYMEVAL-IN-STACK-GROUP 'self *error-sg*))  ;1; *ucl:*stack-group*))1 *;1 TAC 09-02-89*
        (tv-cur-win tv:selected-window)
        (tv-old-sub (AND tv:selected-window (SEND tv:selected-window :selection-substitute)))
        sexp pkg)
    (DECLARE (SPECIAL pkg sexp))
    (DECLARE (SPECIAL *print-array* *print-circle* *print-radix* *nopoint 
		      *print-base* *read-base* *print-level* *print-length*))
    (SEND *window-debugger* :setup-sg *error-sg* *current-frame*)     ;1; this used to be inside the tv:window-call ???*
    ;1; We have to do our own selection substitute stuff here because <abort> throws out of the stack-group, leaving the*
    ;1; clean-up forms undone. CLEAN-UP-WINDOW-DEBUGGER will be called by LEAVING-ERROR-HANDLER in that case.*
    (SEND *window-debugger* :set-tv-current-window tv-cur-win)
    (SEND *window-debugger* :set-tv-old-subst tv-old-sub)
    (UNWIND-PROTECT (PROGN (SEND *window-debugger* :select)
                           (WHEN tv-cur-win
                             (SEND tv-cur-win :set-selection-substitute *window-debugger*))
                           (SETQ *window-debugger-old-window* (OR tv-cur-win t))
                           (SEND *terminal-io* :clear-screen)
                           (SEND *terminal-io* :clear-input)
                           (LET ((+ (SYMEVAL-IN-STACK-GROUP '- *error-sg*))
                                 (* (SYMEVAL-IN-STACK-GROUP '* *error-sg*)))
                             (SEND *window-debugger* :command-loop)))
      (tv:delaying-screen-management (WHEN tv-cur-win
                                       (SEND tv-cur-win :set-selection-substitute tv-old-sub))
                                     (LET ((tv::.flag. (tv:sheet-me-or-my-kid-p tv:selected-window
                                                                                *window-debugger*)))
                                       (SEND *window-debugger* :kill)
                                       (AND tv-cur-win
                                            tv::.flag.
                                            (SEND tv-cur-win :select nil)))))))    

(DEFFLAVOR 4debugger-frame*
           (inspect-window		    ;1; Where the disassembled code goes*
            inspect-history-window	    ;1; History for the inspector*
            args-window			    ;1; The arguments*
            locals-window		    ;1; The locals*
            stack-window		    ;1; Backtrace*
            lisp-window			    ;1; read-eval-print loop window*
            frame-alist			    ;1; Saved frame layout*
            tv-current-window              ;1; window which called the w-d, for selection substitutes*
            tv-old-subst                   ;1; the original selection substitute of the window which called the w-d*
	    resume-menu-window 
	    command-menu-window 
            (inspection-data-active? nil)
            (doing-typein-p nil)
            (who-line-doc-string-overide nil))
           (ucl::basic-command-loop tv:frame-dont-select-inferiors-with-mouse-mixin
                                    tv:bordered-constraint-frame
                                    tv:label-mixin)
  (:gettable-instance-variables lisp-window
                                         doing-typein-p
                                         who-line-doc-string-overide
                                         inspection-data-active? tv-current-window tv-old-subst)
           (:settable-instance-variables doing-typein-p who-line-doc-string-overide tv-current-window tv-old-subst
                                         inspection-data-active? tv-current-window tv-old-subst)
           (:default-init-plist :save-bits
                                t
                                :deexposed-typeout-action
                                :permit
                                :active-command-tables
                                '(window-debugger-general-cmd-table 
                                  window-debugger-stack-cmd-table 
                                  window-debugger-step-cmd-table 
                                  window-debugger-resume-cmd-table)
                                :all-command-tables
                                '(window-debugger-general-cmd-table 
                                  window-debugger-stack-cmd-table 
                                  window-debugger-step-cmd-table 
                                  window-debugger-resume-cmd-table)
                                :menu-panes
                                '((command-menu-window ucl-window-debugger-examine-menu) 
                                  (resume-menu-window ucl-window-debugger-resume-menu))
                                :typein-handler
                                :handle-typein-input
                                :basic-help
                                '(window-debugger-help-cmd))
           (:documentation :special-purpose "3Controls layout of window-based debugger panes*"))

;1****************
;1 TAC 08-04-89 - new definition of this in GENERAL-INSPECT-DEBUGGER*
;1(DEFMETHOD (DEBUGGER-FRAME :BEFORE :INIT) (IGNORE)*

(DEFMETHOD 4(debugger-frame :before :expose*) (&rest ignore)
  "2Necessary for the :ask :pane-size constraint for the menu.*"
  (OR tv:exposed-p (SEND self :set-configuration (SEND self :configuration))))

(DEFMETHOD 4(debugger-frame :after :init*) (IGNORE)
  "2Set up pane bindings and select the interaction pane.*"
  (WITH-SELF-VARIABLES-BOUND (DOLIST (pane  tv::internal-panes)
                               (SET (CAR pane) (CDR pane)))
                             (SEND self :select-pane lisp-window))
  (colorize-debugger-frame))

(DEFUN 4colorize-debugger-frame* ()
  (DECLARE (:self-flavor debugger-frame))
  (SETF (tv::label-background tv::label) w:75%-gray-color)
  (SETF (tv:label-font tv::label) fonts:cptfontb)
  (LET ((cmd-pane (SEND self :get-pane 'command-menu-window))
	(resume-pane (SEND self :get-pane 'resume-menu-window)))
    (SETF (tv::sheet-background-color cmd-pane) w:33%-gray-color)
    (SETF (tv::sheet-background-color resume-pane) w:33%-gray-color)))

(DEFMETHOD 4(debugger-frame :update-print-info*) ()
  (DECLARE (SPECIAL *print-array* *print-circle* *print-radix* *nopoint 
		    *print-base* *read-base* *print-level* *print-length*))
  (SETQ *print-array*  nil)
  (SETQ *print-circle* t)      	;1; default of T so recursive structures print*
  (SETQ *print-level*  8.)
  (SETQ *print-length* 1000.))

(DEFMETHOD 4(debugger-frame :designate-io-streams*) ()
  "2Redefine this UCL method so that the UCL does not rebind the IO.
   Also queue up print-error-message command.*"
  (SEND *terminal-io* :force-kbd-input #\c-l)
  (SETQ *standard-output* *terminal-io*)
  (SETQ *standard-input* *terminal-io*)
  (SETQ *query-io* *terminal-io*)
  (SETQ *error-output* *terminal-io*)
  (SETQ *debug-io* *terminal-io*))

(DEFMETHOD 4(debugger-frame :around :handle-typein-input*) (cont mt ignore &optional 
                                                          (untyi-first-char? t))
  "2Set a var to signal the who line methods we are doing typein.*"
  (SEND *window-debugger* :set-doing-typein-p t)
  (UNWIND-PROTECT (FUNCALL-WITH-MAPPING-TABLE cont mt :handle-typein-input untyi-first-char?)
                  (SEND *window-debugger* :set-doing-typein-p nil)))

(DEFMETHOD 4(debugger-frame :around :fetch-and-execute*) (cont mt ignore)
  "2Set a couple of variables and check for command aborts.*"
  (DECLARE (SPECIAL pkg))
  (SETQ pkg (SYMEVAL-IN-STACK-GROUP '*package* *error-sg*))		;1; jlm 4/6/89*
  ;1(SETQ *PACKAGE* (IF (TYPEP PKG 'PACKAGE) PKG (FIND-PACKAGE "USER")))*
  (SETQ *package* (IF (PACKAGEP pkg) pkg (FIND-PACKAGE "3USER*")))
  (CATCH 'quit (FUNCALL-WITH-MAPPING-TABLE cont mt :fetch-and-execute)))

;1; line-area should delete and set to *. Need to write update-panes and replace :line-area code. also move it before*
;1; the case operation.*
;1              (:LINE-AREA*
;1                (COND ((SEND *WINDOW-DEBUGGER* :INSPECT-WINDOW-P window)*
;1                       (COND ((= (fourth ucl::kbd-input) #\MOUSE-M)*
;1                              ;; Delete from line area*
;1                              (SEND inspect-HISTORY-window :FLUSH-OBJECT (tv:INSPECT-REAL-VALUE UCL::KBD-INPUT))*
;1                              (SEND inspect-HISTORY-window :SET-CACHE NIL)*
;1                              (update-panes????))*
;1                             ((EQ (INT-CHAR (FOURTH list)) #\MOUSE-L)*
;1                              (SETQ OPERATION :VALUE*
;1                              VALUE (TV::INSPECT-REAL-VALUE LIST))))*
;1                      (t*
;1                        (SETQ *CURRENT-FRAME* VALUE)*
;1                        (SEND *WINDOW-DEBUGGER* :SETUP-FRAME SG *CURRENT-FRAME*))))*

;1; change SYS:DEBUG-UTILITIES;WINDOW-DEBUG.LISP#205 to not use AP but FRAME *
;1; and to reference args and locals in reg pdl correctly*
;1; Intercept blips.  May want to redo this with the UCL blip processing when it is available.*
(DEFMETHOD 4(debugger-frame :around :handle-unknown-input*) (cont mt ignore)
  (LET (operation value window list (sg *error-sg*))
    (WHEN (LISTP ucl:kbd-input)
      (SETQ list ucl:kbd-input
            operation (FIRST list)
            value (SECOND list)
            window (THIRD list))
      (WHEN (NOT (MEMBER operation '(:line-area :mouse-button) :test (FUNCTION eq)))
        (IF (EQL (INT-CHAR (FOURTH list)) #\Mouse-l)      ;1.*
            (SETQ operation :inspect)
            (IF (SEND *window-debugger* :inspect-window-p window)
                (SETQ operation :value
                      value (tv::inspect-real-value list))))))
    (IF (NOT (MEMBER operation '(:line-area :inspect :value :function stack-frame special arg 
                                            local) :test (FUNCTION eq)))
        (FUNCALL-WITH-MAPPING-TABLE cont mt :handle-unknown-input)
        (CASE operation
              (:line-area
                (UNLESS (SEND *window-debugger* :inspect-window-p window)   ;1; see above comments!*
                        (SETQ *current-frame* value)
 ;1; TAC 09-02-89*	       1  *;1; *(SETF ucl:top-level-self (SYMEVAL-IN-STACK-GROUP 'self ucl:*stack-group* *current-frame*))
			(SETF ucl::top-level-self (SYMEVAL-IN-STACK-GROUP 'self *error-sg* *current-frame*))
                        (SEND *window-debugger* :setup-frame sg *current-frame*)))
              (:inspect
         (IF (SEND *window-debugger* :inspect-window-p window)
             (SEND *window-debugger* :inspect-object (tv::inspect-real-value list))
             (SEND *window-debugger* :inspect-object
                   (CASE (FIRST list)
                         (:menu  (EQ (SEND (FOURTH list) :execute (SECOND list)) t))
                         (stack-frame  (list-stack-frame-function-and-args *error-sg*
                                                                           (SECOND list)))
                         (:line-area  (list-stack-frame-function-and-args *error-sg*
                                                                          (SECOND list)))
                         ((SPECIAL arg local)  (FIRST (SECOND list)))
                         ((:value :function)  (SECOND list))))))
              ((LIST :value :function stack-frame special arg local)
               (SETQ +++ ++
                     ++  +)
               (COND
                 ((MEMBER operation '(SPECIAL arg local) :test (FUNCTION eq))
                  (COND
                    ((MEMBER operation '(arg local) :test (FUNCTION eq))
                     (PRIN1 (FIRST value))
                     (LET ((idx (SECOND value)))
                       (IF (NOT (NUMBERP idx))
                           (AND (EQUALP idx "3Rest arg*")
                             (SETQ value (sg-rest-arg-value sg *current-frame*)))
                           (PROGN
                             (LET ((rp (sg-regular-pdl sg)))
                               (SETQ +
                                     (ALOC rp
                                           (+ idx
                                              (IF (EQ operation 'arg) 
                                                  (sys:rp-argument-offset sg rp *current-frame*)
                                                  (sys:rp-local-offset sg rp *current-frame*))))))
                                                      ;1  old way of looking for args and locals:*
                                                      ;1    *			1 (ALOC RP*
                                                      ;			1       (+ *CURRENT-FRAME* IDX*
                                                      ;				1  (IF (EQ OPERATION 'ARG) 1*
                                                      ;				1    (RP-LOCAL-BLOCK-ORIGIN*
                                                      ;				1      RP CURRENT-FRAME))))))*
                             (SETQ value (CAR +))))))
                    (t (SETQ + (PRIN1 value))
                       (SETQ value (SYMBOL-VALUE value))))
                  (TERPRI))
                 ((EQ operation 'stack-frame)
                  (SETQ value (stack-frame-into-list value sg))))
               (SEND *terminal-io* :fresh-line)
               (SETQ *** **
                     **  *
                     *   (PRIN1 value))
               (SEND self :handle-prompt))))))

(DEFCOMMAND 4comw-what-error-cmd*
            nil
            '(:description  "3Re-print the error message for the current error.*"
              :names "3Error*"
              :keys (#\c-l))
            (SEND *terminal-io* :clear-screen)
            (comw-what-error *error-sg* *error-object*)
            (SEND *window-debugger* :handle-prompt))

(DEFCOMMAND 4bug-report-cmd*
            nil
            '(:description  
              "3Mail a bug report containing the error message and a backtrace of the stack.*" 
              :names "3Report*"
              :keys (#\c-m))
            (com-bug-report *error-sg* *error-object*))

;1****************
;1 TAC 08-01-89 - new definition from DEVELOPMENT-TOOLS-CONSISTENCY-ENHANCEMENTS follows.*
;1(DEFCOMMAND COMW-ARGLIST-CMD NIL*

;1****************
;1 TAC 08-01-89 - keystrokes are made compatible with zmacs*
;1-------------------------------------------------------------------------------*
;1 The Arglist command in the window debugger.*
;1-------------------------------------------------------------------------------*
;1; Redefine the arglist command so that it will take c-sh-a as a key*
;1; assignment for compatibility with ZMacs.*

(DEFCOMMAND 4comw-arglist-cmd* nil
  '(:description "3Display the argument list of a specified function.*"
    :names "3Arglist*"
    :keys (#\c-a #\c-sh-a))
   (SEND *window-debugger* :set-who-line-doc-string-overide
	 "3Select a function to apply Arglist to.*")
   (UNWIND-PROTECT (comw-arglist *error-sg* *error-object*)
     (PROGN (SEND *window-debugger* :set-who-line-doc-string-overide nil)
	    (SEND *window-debugger* :handle-prompt))))
;1-------------------------------------------------------------------------------*

(DEFCOMMAND 4com-return-reinvocation-cmd* nil
            '(:description  
              "3Retry from the beginning of the function call represented by the current frame.*"
               :names "3Retry*"
            :keys (#\c-m-r))
            (com-return-reinvocation *error-sg* *error-object*))

(DEFCOMMAND 4step-cmd* nil
 (QUOTE
  (:description
     "3Step from the current point of execution in the current frame (Resume from the current frame, and trap on entry to the next function call).*"
     :names "3Step*"
     :keys (#\c-d)))
 (com-proceed-trap-on-call *error-sg* *error-object*))

(DEFCOMMAND 4stay-cmd* nil
 (QUOTE
  (:description
     "3Toggle the variable eh:*enter-window-debugger* to use the regular or window-based debugger.*"
    :names "3Stay*"
   :keys (#\h-s)))
 (FORMAT t "3~&Setting eh:*enter-window-debugger* to ~S~%*"
         (SETQ eh::*enter-window-debugger* (IF eh::*enter-window-debugger* nil :always)))
 (SEND *window-debugger* :handle-prompt))

(DEFCOMMAND 4toggle-config-cmd* nil
 '(:description  
   "3Toggle between the stepping configuration and the default debugging configuration.*"  
   :names "3Config*"
   :keys (#\h-c))
 (LET ((current-cfg (SEND *window-debugger* :configuration)))
   (tv:delaying-screen-management (IF (EQUAL current-cfg 'debugger-configuration)
                                      (SEND *window-debugger*
                                            :set-configuration
                                            'step-configuration)
                                      (SEND *window-debugger*
                                            :set-configuration
                                            'debugger-configuration)))))

(DEFCOMMAND 4com-toggle-trap-on-call-cmd* nil
   '(:description  "3Toggle the flag that causes a trap on the next function call.*" 
    :names "3Bk Next*"
    :keys (#\m-d))
   (com-toggle-trap-on-call *error-sg* *error-object*)
   (SEND *window-debugger* :handle-prompt))


(DEFCOMMAND 4com-toggle-frame-trap-on-exit-cmd* nil
   (QUOTE
      (:description
         "3Toggle the flag in the current frame that causes a trap on exit or throw through the frame.*"
       :names "3Bk Exit*"
       :keys (#\c-x)))
   (com-toggle-frame-trap-on-exit *error-sg* *error-object*)
   (SEND *window-debugger* :handle-prompt))

(DEFVAR 4toggle-all-frames-switch* nil
        "2Used by the com-toggle-all-frames-trap-on-exit-cmd to record its last setting.*")

(DEFCOMMAND 4com-toggle-all-frames-trap-on-exit-cmd* nil
   (QUOTE (:description
	    "3Toggle the flag causing a trap on exit or throw through the frame for the current frame and all outer frames.*"
	   :names "3Bk All*"
	   :keys (#\s-x)))
   (IF toggle-all-frames-switch
         (com-clear-all-frames-trap-on-exit *error-sg* *error-object*)
         (com-set-all-frames-trap-on-exit *error-sg* *error-object*))
   (SETQ toggle-all-frames-switch (NOT toggle-all-frames-switch)))

(DEFCOMMAND 4com-set-all-frames-trap-on-exit-cmd* nil
   (QUOTE (:description
	    "3Set the flag causing a trap on exit or throw through the frame for the current frame and all outer frames.*"
	   :names "3Set All*"
	   :keys (#\m-x)))
   (com-set-all-frames-trap-on-exit *error-sg* *error-object*)
   (SEND *window-debugger* :handle-prompt))

(DEFCOMMAND 4com-clear-all-frames-trap-on-exit-cmd* nil
 (QUOTE
  (:description
     "3Clear the flag causing a trap on exit or throw through the frame for the current frame and all outer frames.*"
    :names "3Clear All*"
   :keys (#\c-m-x)))
 (com-clear-all-frames-trap-on-exit *error-sg* *error-object*)
 (SEND *window-debugger* :handle-prompt))

(DEFCOMMAND 4comw-set-arg-cmd* nil
   '(:description  "3Modify an argument or local in the current frame.*"
    :names "3Modify*"
    :keys (#\c-m-a #\c-m-l))
   (SEND *window-debugger*
	 :set-who-line-doc-string-overide
	 "3Select an argument or local to modify.*")
   (UNWIND-PROTECT (comw-set-arg *error-sg* *error-object*)
      (PROGN (SEND *window-debugger*
		   :set-who-line-doc-string-overide
		   nil)
	     (SEND *window-debugger* :handle-prompt))))

(DEFCOMMAND 4comw-exit-cmd* nil			;1!*
  '(:description  "3Return to the regular debugger, but don't leave error context.*" 
		  :names "3End*"
		  :keys (#\End))
  (SEND *window-debugger* :quit))

;1****************
;1 TAC 08-01-89 - new definition from DEVELOPMENT-TOOLS-CONSISTENCY-ENHANCEMENTS follows*
;1(DEFCOMMAND COMW-INSPECT-CMD NIL*

;1****************
;1 TAC 08-01-89 - moved this code from DEVELOPMENT-TOOLS-CONSISTENCY-ENHANCEMENTS*
;1-------------------------------------------------------------------------------*
;1; Add key assignments to the inspect command in the debugger.*

(DEFCOMMAND 4comw-inspect-cmd* nil
 '(:description  "3Inspect an object specified with keyboard or mouse.*"
   :names "3Inspect*" 
   :keys (#\c-sh-i #\M-sh-i #\c-i))
 (SEND *window-debugger* :set-who-line-doc-string-overide "3Select an object to inspect.*")
 (UNWIND-PROTECT
  (PROGN
   (comw-inspect *error-sg* *error-object*)
   (tv:delaying-screen-management
    (WHEN (EQUAL (SEND *window-debugger* :configuration) 'step-configuration)
      (SEND *window-debugger* :set-configuration 'debugger-configuration))))
  (PROGN (SEND *window-debugger* :set-who-line-doc-string-overide nil)
         (SEND *window-debugger* :handle-prompt))))
;1-------------------------------------------------------------------------------*

(DEFCOMMAND 4com-return-a-value-cmd* ()
            '(:description  "3Return a value as the result from the current frame.*"
              :names "3Return*"
              :keys (#\c-r))
            (SEND *window-debugger*
                  :set-who-line-doc-string-overide
                  "3Select an object to evaluate and return.*")
            (UNWIND-PROTECT (com-return-a-value *error-sg* *error-object*)
                            (PROGN (SEND *window-debugger*
                                         :set-who-line-doc-string-overide
                                         nil)
                                   (SEND *window-debugger* :handle-prompt))))

(DEFCOMMAND 4com-top-level-throw-cmd* nil
            '(:description  "3Leave the debugger and abort the program.*"  :names "3Abort*" 
              :keys (#\c-m-abort #\s-end))
            (com-top-level-throw *error-sg* *error-object*))

;1---------------------------------------------------------------------------*
;1 TAC 08-01-89 - moved comw-search up near comw-search-cmd. *
(DEFUN 4comw-search* (sg ignore)
  (LET (key frame)
    (FORMAT t "3String to search for (end with RETURN):~%*")
    (SETQ key (READ-LINE))
    (SETQ frame 
          (DO ((frame *current-frame* (sg-next-frame sg frame))
               (rp (sg-regular-pdl sg))
               (name))
              ((NULL frame) nil)
            (SETQ name (FUNCTION-NAME (rp-function-word rp frame)))
            (SETQ name (COND ((STRINGP name) name)
                             ((SYMBOLP name) (STRING name))
                             (t (FORMAT nil "3~S*" name))))
            (AND (SEARCH key name :test #'STRING-EQUAL) (RETURN frame))))
    (COND ((NULL frame)
           (FORMAT t "3Search failed.~%*"))
          (t
           (SETQ *current-frame* frame)
 ;1; TAC 09-02-89*  (SETF ucl:top-level-self (SYMEVAL-IN-STACK-GROUP 'self ucl:*stack-group* *current-frame*))
	   (SETF ucl::top-level-self (SYMEVAL-IN-STACK-GROUP 'self *error-sg* *current-frame*))
           (SEND *window-debugger* :setup-frame sg *current-frame*)))))

(DEFCOMMAND 4comw-search-cmd* nil
            '(:description  
              "3Search stack for a frame whose function's name contains a specified string.*"  
              :names "3Search*"
              :keys (#\c-s))
            (UNWIND-PROTECT (comw-search *error-sg* *error-object*)
                            (SEND *window-debugger* :handle-prompt)))
;1------------------------------------------------------------------------------*

;1****************
;1 TAC 08-01-89 - comw-edit and comw-edit-cmd redefined  in DEVELOPMENT-TOOLS-CONSISTENCY-ENHANCEMENTS*

;1(DEFUN COMW-EDIT (IGNORE IGNORE)*

;1(DEFCOMMAND COMW-EDIT-CMD NIL*
;1----------------------------------*

(DEFCOMMAND 4com-proceed-cmd* nil
   (QUOTE
      (:description
         "3Attempt to proceed from the error using default proceed type.  R: Menu of available proceed types.*"
         :names "3Resume*"
         :keys (#\Resume)))
   (LET ((input ucl::kbd-input))
      (DECLARE (SPECIAL *error-object* ucl::kbd-input))
      (IF (AND (CONSP input)
	        (EQ (FIRST input) :menu)
	        (EQ (THIRD input) 4))
	 (comw-proceed *error-sg* *error-object*)
	 (com-proceed *error-sg* *error-object*))))

(DEFCOMMAND 4com-throw-cmd* nil
   '(:description  "3Throw a specified value to a specified tag.*"
    :names "3Throw*" 
    :keys (#\c-t))
   (SEND *window-debugger*
	 :set-who-line-doc-string-overide
	 "3Select objects to evaluate for tag and value to throw.*")
   (UNWIND-PROTECT (com-throw *error-sg* *error-object*)	       ;
      (PROGN (SEND *window-debugger*
		   :set-who-line-doc-string-overide
		   nil)
	     (SEND *window-debugger* :handle-prompt))))

;1----------------------------------------------------------------*
;1 TAC 08-01-89 - being redefined *

;1(DEFUN WINDOW-DEBUGGER-HELP (&OPTIONAL IGNORE IGNORE)*

;1****************
;1 TAC 08-01-89 - new code from DEVELOPMENT-TOOLS-CONSISTENCY-ENHANCEMENTS*
;1-------------------------------------------------------------------------------*
;1 The window debugger Help command.  This used to be the document command.*
;1-------------------------------------------------------------------------------*

(DEFUN 4window-debugger-help* (&optional ignore ignore)
  (DECLARE (SPECIAL *window-debugger*))
  (si:with-help-stream (window :label
                               "3Help for Window-based debugger*"
                               :superior
                               tv:default-screen)
    (FORMAT window "
                                 WINDOW-BASED DEBUGGER HELP

----------------------------------------------------------------------------------------------
                                   *** INSPECTION PANE ***

     This pane displays the structure of the most recently inspected item.  By default
     the item inspected here is the selected stack frame.  To inspect other items here, 
     use the Inspect command or click Mouse-Left on them in this pane or 
     in the Inspection History Pane.

----------------------------------------------------------------------------------------------
             *** ARGS PANE ***                 |             *** LOCALS PANE ***
                                               |
     This pane displays the argument           |     This pane displays the local variable
     values for the currently selected         |     values and the special variable values
     frame if there are any.  Otherwise,       |     for the currently selected frame if
     this pane is gray.                        |     there are any.  Otherwise, this pane
                                               |     is gray.
                                               |
----------------------------------------------------------------------------------------------
                                      *** STACK PANE ***

     This pane displays the execution stack that contained the error.  The contents of the 
     above three panes are determined by the frame that is selected.  The selected frame is
     the frame in this pane with the small arrow pointing to it.

     To select another frame to see its args\/locals\/specials\/code use the up\/down
     commands or move the mouse cursor to where you want the new arrow to be.  Then click 
     Mouse-Left when the cursor changes back to the small arrow.

----------------------------------------------------------------------------------------------
*** MENU PANE ***    |                   *** INSPECTION HISTORY PANE ***
                     |
Click Mouse-Left     |     This pane maintains a history of objects that have appeared 
to select a          |     in the Inspection Pane.  To see these objects in the Inspection
command.             |     Pane again, click Mouse-Left on them here.
                     |
----------------------------------------------------------------------------------------------
                                    *** INTERACTION PANE ***

This pane is used to output messages and to evaluate Lisp forms.  Clicking Mouse-Left on
mouse-sensitive items within the Args, Locals, or Stack panes will print them out here and
will set * to these items.

----------------------------------------------------------------------------------------------



 ")
    (tv::show-all-commands-for-frame *window-debugger* window)))

(DEFCOMMAND 4window-debugger-help-cmd* ()
            '(:description "3Show documentation for each of the panes.*"
			    :names "3Help*"
			    :keys (#\c-help #\m-help))
             (window-debugger-help *error-sg* *error-object*))
;1-----------------------------------------------------------------------------------*

(DEFCOMMAND 4clear-screen-cmd* ()            
            '(:description  "3Clear Lisp interactor pane.*"
              :names "3Clear Screen*"
              :keys (#\Page))
            (SEND *terminal-io* :clear-screen))

(DEFCOMMAND 4up-stack-cmd* (*numeric-arg* &aux items current-item item-idx)   ;1!*
            '(:description  "3Move up the stack one frame.*"
              :names "3up*"
              :keys (#\c-p #\)
              :arguments (ucl:numeric-argument))
            (SETQ items (SEND (SEND *window-debugger* :get-pane 'stack-window) :items)
                  current-item (SEND (SEND *window-debugger* :get-pane 'stack-window)
                                     :current-item)
                  item-idx (DOTIMES (i  (ARRAY-ACTIVE-LENGTH items))
                    (WHEN (EQ (AREF items i) current-item)
                      (RETURN i)))
                  *numeric-arg* (IF (NULL *numeric-arg*) 1 *numeric-arg*))
            (IF (MINUSP (- item-idx *numeric-arg*))
                (BEEP)
                (PROGN (SETQ *current-frame* (AREF items (- item-idx *numeric-arg*)))
                       (SEND *window-debugger* :setup-frame *error-sg* *current-frame*)))
 ;1; TAC 09-02-89* (SETF ucl:top-level-self (SYMEVAL-IN-STACK-GROUP 'self ucl:*stack-group* *current-frame*))
	    (SETF ucl::top-level-self (SYMEVAL-IN-STACK-GROUP 'self *error-sg* *current-frame*)))

(DEFCOMMAND 4down-stack-cmd* (*numeric-arg* &aux items current-item item-idx)
            '(:description  "3Move down the stack one frame.*"
              :names "3Down*"
              :keys (#\c-n #\)
              :arguments (ucl:numeric-argument))
            (SETQ items (SEND (SEND *window-debugger* :get-pane 'stack-window) :items)
                  current-item (SEND (SEND *window-debugger* :get-pane 'stack-window)
                                     :current-item)
                  item-idx (DOTIMES (i  (ARRAY-ACTIVE-LENGTH items))
                    (WHEN (EQ (AREF items i) current-item)
                      (RETURN i)))
                  *numeric-arg* (IF (NULL *numeric-arg*) 1 *numeric-arg*))
            (IF (>= (+ *numeric-arg* item-idx) (ARRAY-ACTIVE-LENGTH items))
                (BEEP)
                (PROGN (SETQ *current-frame* (AREF items (+ *numeric-arg* item-idx)))
                       (SEND *window-debugger* :setup-frame *error-sg* *current-frame*)))
 ;1; TAC 09-02-89* (SETF ucl:top-level-self (SYMEVAL-IN-STACK-GROUP 'self ucl:*stack-group* *current-frame*))
	    (SETF ucl::top-level-self (SYMEVAL-IN-STACK-GROUP 'self *error-sg* *current-frame*)))

(DEFCOMMAND 4top-stack-cmd* (&aux items)
            '(:description  "3Move to the top of the stack.*"
              :names "3Top*"
              :keys (#\m-< #\h-))
            (SETQ items (SEND (SEND *window-debugger* :get-pane 'stack-window) :items))
            (SETQ *current-frame* (AREF items 0))
            (SEND *window-debugger* :setup-frame *error-sg* *current-frame*)
 ;1; TAC 09-02-89 *(SETF ucl:top-level-self (SYMEVAL-IN-STACK-GROUP 'self ucl:*stack-group* *current-frame*))
	    (SETF ucl::top-level-self (SYMEVAL-IN-STACK-GROUP 'self eh:*error-sg* *current-frame*)))

(DEFCOMMAND 4bottom-stack-cmd* (&aux items)
            '(:description  "3Move to the bottom of the stack.*"
              :names "3bottom*"
              :keys (#\m-> #\h-))
            (SETQ items (SEND (SEND *window-debugger* :get-pane 'stack-window) :items))
            (SETQ *current-frame* (AREF items (1- (ARRAY-ACTIVE-LENGTH items))))
            (SEND *window-debugger* :setup-frame *error-sg* *current-frame*)
 ;1; TAC 09-02-89* (SETF ucl:top-level-self (SYMEVAL-IN-STACK-GROUP 'self ucl:*stack-group* *current-frame*))
	    (SETF ucl::top-level-self (SYMEVAL-IN-STACK-GROUP 'self *error-sg* *current-frame*)))

(DEFCOMMAND 4page-up-stack-cmd* ()
            '(:description  "3Move up a page in the stack window.*"
              :names "3page up*"
              :keys (#\m-v #\c-))
            (SEND (SEND *window-debugger* :get-pane 'stack-window)
                  :scroll-relative
                  :top
                  :bottom)
;1; TAC 09-02-89*  (SETF ucl:top-level-self (SYMEVAL-IN-STACK-GROUP 'self ucl:*stack-group* *current-frame*))
	    (SETF ucl::top-level-self (SYMEVAL-IN-STACK-GROUP 'self *error-sg* *current-frame*)))

(DEFCOMMAND 4page-down-stack-cmd* ()
	    '(:description  "3Move down a page in the stack window.*"
              :names "3Page Down*" 
              :keys (#\c-v #\c-))
            (SEND (SEND *window-debugger* :get-pane 'stack-window)
                  :scroll-relative
                  :bottom
                  :top)
;1; TAC 09-02-89* (SETF ucl:top-level-self (SYMEVAL-IN-STACK-GROUP 'self ucl:*stack-group* *current-frame*))
	    (SETF ucl::top-level-self (SYMEVAL-IN-STACK-GROUP 'self *error-sg* *current-frame*))) 

(DEFPARAMETER 4*window-debugger-all-commands-menu** nil "2Holds a menu item list.*")

(MAKE-COMMAND all-commands-menu-cmd
  '(:names "3All cmds*"
    :keys #\Mouse-r-1
    :definition ucl::pop-up-command-menu
    :arguments ('*window-debugger-all-commands-menu*)))

(BUILD-COMMAND-TABLE 'window-debugger-general-cmd-table
                     'debugger-frame
                     '(comw-what-error-cmd comw-arglist-cmd comw-exit-cmd comw-inspect-cmd 
                       com-top-level-throw-cmd comw-edit-cmd window-debugger-help-cmd 
                       clear-screen-cmd bug-report-cmd all-commands-menu-cmd)
                     :init-options
                     '(:name "3General window-based debugger commands*"))

(BUILD-COMMAND-TABLE 'window-debugger-stack-cmd-table
                     'debugger-frame
                     '(comw-search-cmd up-stack-cmd down-stack-cmd page-up-stack-cmd 
                       page-down-stack-cmd top-stack-cmd bottom-stack-cmd)
                     :init-options
                     '(:name "3Commands for looking at the stack*"))

(BUILD-COMMAND-TABLE 'window-debugger-step-cmd-table
                     'debugger-frame
                     '(step-cmd com-toggle-trap-on-call-cmd com-toggle-frame-trap-on-exit-cmd 
                       com-set-all-frames-trap-on-exit-cmd 
                       com-clear-all-frames-trap-on-exit-cmd 
                       com-toggle-all-frames-trap-on-exit-cmd toggle-config-cmd stay-cmd)
                     :init-options
                     '(:name "3Commands for stepping through program execution*"))

(BUILD-COMMAND-TABLE 'window-debugger-resume-cmd-table
                     'debugger-frame
                     '(com-return-reinvocation-cmd comw-set-arg-cmd com-return-a-value-cmd 
                       com-proceed-cmd com-throw-cmd)
                     :init-options
                     '(:name "3Commands for resuming program execution*"))
 
(BUILD-MENU 'ucl-window-debugger-examine-menu
            'debugger-frame
            :default-item-options
            '(:font fonts:cptfont)
            :item-list-order
            '(("3Examine*" :font fonts:hl10b) comw-inspect-cmd window-debugger-help-cmd 
              comw-edit-cmd  comw-search-cmd bug-report-cmd comw-what-error-cmd 
              comw-arglist-cmd stay-cmd comw-set-arg-cmd ))


(BUILD-MENU 'ucl-window-debugger-resume-menu
            'debugger-frame
            :default-item-options
            '(:font fonts:cptfont)
            :item-list-order
            '(("3Resume*" :font fonts:hl10b) com-toggle-trap-on-call-cmd 
              com-return-reinvocation-cmd com-toggle-frame-trap-on-exit-cmd com-proceed-cmd 
              com-toggle-all-frames-trap-on-exit-cmd com-return-a-value-cmd step-cmd 
              com-top-level-throw-cmd comw-exit-cmd))


(BUILD-MENU '*window-debugger-all-commands-menu*
            'debugger-frame
            :item-list-order
            '((comw-what-error-cmd :column "3General*") (comw-arglist-cmd :column "3General*") 
              (comw-exit-cmd :column "3General*") (comw-inspect-cmd :column "3General*") 
              (com-top-level-throw-cmd :column "3General*") (comw-edit-cmd :column "3General*") 
              (window-debugger-help-cmd :column "3General*") (clear-screen-cmd :column "3General*")
              (bug-report-cmd :column "3General*") (comw-search-cmd :column "3Stack*") 
              (up-stack-cmd :column "3Stack*") (down-stack-cmd :column "3Stack*") 
              (page-up-stack-cmd :column "3Stack*") (page-down-stack-cmd :column "3Stack*") 
              (top-stack-cmd :column "3Stack*") (bottom-stack-cmd :column "3Stack*") 
              (step-cmd :column "3Step*") (com-toggle-trap-on-call-cmd :column "3Step*") 
              (com-toggle-frame-trap-on-exit-cmd :column "3Step*") 
              (com-set-all-frames-trap-on-exit-cmd :column "3Step*") 
              (com-clear-all-frames-trap-on-exit-cmd :column "3Step*") 
              (com-toggle-all-frames-trap-on-exit-cmd :column "3Step*") 
              (toggle-config-cmd :column "3Step*") (stay-cmd :column "3Step*") 
              (com-return-reinvocation-cmd :column "3Resume*") 
              (comw-set-arg-cmd :column "3Resume*") (com-return-a-value-cmd :column "3Resume*") 
              (com-proceed-cmd :column "3Resume*") (com-throw-cmd :column "3Resume*"))
            :column-list-order
            '(("3General*" :font fonts:hl12b) ("3Stack*" :font fonts:hl12b) 
              ("3Step*" :font fonts:hl12b) ("3Resume*" :font fonts:hl12b)))




(DEFMETHOD 4(debugger-frame :inspect-window-p*) (w) 
  (OR (EQ w inspect-history-window)
      (EQ w inspect-window)))

(DEFMETHOD 4(debugger-frame :select*) (&rest args)
  (APPLY lisp-window :select args)
  (SEND self :expose))

(DEFMETHOD 4(debugger-frame :deselect*) (&rest args)
  (APPLY lisp-window :deselect args))

(DEFMETHOD 4(debugger-frame :name-for-selection*) ()
  tv:name)

(DEFMETHOD 4(debugger-frame :set-sensitive-item-types*) (val)
  (SEND args-window :set-sensitive-item-types val)
  (SEND locals-window :set-sensitive-item-types val)
  (SEND stack-window :set-sensitive-item-types val))

(DEFMETHOD 4(debugger-frame :sensitive-item-types*) ()
  (SEND locals-window :sensitive-item-types))

(DEFMETHOD 4(debugger-frame :inspect-object*) (thing)	   ;1.*
  (SEND inspect-history-window
        :inspect-object
        thing
        inspect-window nil nil nil t)) ;1; added extra arg so that same symbol in differing frames will be updated correctly*

;1; change SYS:DEBUG-UTILITIES;WINDOW-DEBUG.LISP#205 to not use AP but FRAME *
;1; and to reference args and locals in reg pdl correctly*
(DEFMETHOD 4(debugger-frame :setup-sg*) (sg frame)
  (SETQ frame-alist nil)
  (SEND inspect-history-window :flush-contents)
  (setup-stack-frame-window stack-window sg)
  (SEND self :setup-frame sg frame))

(DEFMETHOD 4(debugger-frame :setup-frame*) (sg frame &optional force-p arg-changed-flag)
  (LET (code args locals tem)
    (OR tv:exposed-p
        ;1; If window not exposed, get its bit array in core so setup will go faster*
        (si:page-in-array tv:screen-array))
    (SETQ tem (ASSOC frame frame-alist :test (FUNCTION eq)))
    (COND (force-p
           (SETQ frame-alist (DELETE tem (THE list frame-alist) :test #'EQ))
           (SETQ tem nil)))
    ;1; Set stuff up in most interesting order: args, then locals, then code*
    (COND (tem ;1; Displayed this before*
           (SEND args-window :setup (THIRD tem))
           (SEND locals-window :setup (FOURTH tem))
           (SEND inspect-history-window :inspect-object (SECOND tem) inspect-window))
          (t
           (MULTIPLE-VALUE-SETQ (args tem) (setup-args-window args-window sg frame))
           (SETQ locals (setup-locals-window locals-window sg frame tem))
           (SETQ code (setup-inspect-window inspect-window sg frame inspect-history-window))
           (PUSH (LIST frame code args locals) frame-alist)))
    (IF arg-changed-flag
        (SEND stack-window :refresh))
    (SEND stack-window :put-item-in-window frame)
    (SEND stack-window :set-current-item frame)))


;1; Support routines for the stack frame window, a stack frame entry is just an AP.*
;1; The common argument is the stack group.*
;1; Top of stack really on top - mjf*

;1; change SYS:DEBUG-UTILITIES;WINDOW-DEBUG.LISP#205 to not use AP but FRAME *
;1; and to reference args and locals in reg pdl correctly*

(DEFUN 4setup-stack-frame-window* (window sg )
  (LET (LIST)
    (DO ((frame (sys:sg-top-frame sg) (sg-next-frame sg frame)))
        ((NULL frame))
      (PUSH frame list))
    (SEND window :setup (LIST 'print-stack-frame sg (NREVERSE list)))))

;1; Given an SG and a FRAME, return the function and first and last+1 arg index into the RP (3 values).*
(DEFUN 4stack-frame-function-and-args* (sg frame)
  (DECLARE (VALUES function args-start args-end))
  (PROG* ((rp (sg-regular-pdl sg))
	  (FUNCTION (rp-function-word rp frame))
	  (argument-index (sys:rp-argument-offset sg rp frame)))
    ;1; If SELF is bound by this frame to an object whose handler for the first argument to this*
    ;1; frame is the function of this frame, print that object instead.*
    (LET ((idx (sg-frame-special-pdl-range sg frame)))
      (AND idx
	   (> idx 0)
	   (LET ((sp (sg-special-pdl sg)))
	     (AND (EQ (AREF sp (1+ idx))
		      (%make-pointer dtp-locative (si:%p-pointer-offset 'self 1)))  
;1; TGC*		1      (%MAKE-POINTER DTP-LOCATIVE (%P-LDB-OFFSET %%Q-POINTER 'SELF 1)))*
		  (LET* ((object (AREF sp idx))
			 (handler (GET-HANDLER-FOR object (AREF rp argument-index))))
		    (AND (IF handler
			     (EQ function (IF (SYMBOLP handler) (SYMBOL-FUNCTION handler) handler))
			   (MEMBER (FUNCTION-NAME function)
                                   '(si::instance-hash-failure
                                     si::flavor-unclaimed-message
                                     si::report-unclaimed-message)
                                   :test
                                   (FUNCTION eq)))
			 (SETQ function object)))))))
    (RETURN (VALUES function argument-index (+ argument-index (rp-number-args-supplied rp frame))))))

;1; Print a frame  (ITEM is a FRAME)*
(DEFUN 4print-stack-frame* (item sg stream ignore)
  (SEND stream :item1 item 'stack-frame #'print-stack-frame-1 sg))

(DEFUN 4print-stack-frame-1* (frame stream sg)
  (MULTIPLE-VALUE-BIND (FUNCTION args-start args-end) (stack-frame-function-and-args sg frame)
    (SEND stream :tyo (si::pttbl-open-paren *readtable*))
    (SEND stream :item1 function :function #'(lambda (FUNCTION stream)
						    (PRIN1 (FUNCTION-NAME function) stream)))
    (DO ((arg-idx args-start (1+ arg-idx))
	 (LENGTH 1 (1+ length))
	 (rp (sg-regular-pdl sg)))
	((>= arg-idx args-end)
	 (SEND stream :tyo (si::pttbl-close-paren *readtable*)))
      (SEND stream :tyo (si::pttbl-space *readtable*))
      (SEND stream :item1 (AREF rp arg-idx) :value #'tv::print-item-concisely)
      (COND ((AND *print-length* (>= length *print-length*))
	     (SEND stream :string-out (si::pttbl-prinlength *readtable*))
	     (RETURN nil))))))


;1; Support routines for the args, locals, and specials windows*
;1; Entries are fixed strings, or lists of name, val, and number*
;1; Common arg is the type of entries present*
(DEFUN 4setup-args-window* (window sg frame)
  (LET* (LIST
         (rp (sg-regular-pdl sg))
         (argument-index (sys:rp-argument-offset sg rp frame))
         (FUNCTION (rp-function-word rp frame))
         (nargs-supplied (rp-number-args-supplied rp frame))
         (nargs-to-print (sg-number-of-spread-args sg frame))
         nargs-expected nargs-required
         lexpr-call rest-arg-p rest-arg-value)
    (IF (OR (TYPEP function 'compiled-function)
            (AND (TYPEP function 'CONS) (MEMBER (FIRST function) si:function-start-symbols)))
        (MULTIPLE-VALUE-SETQ (nargs-required nargs-expected ) (si::args-desc function)))
;1    (IF (TYPEP FUNCTION '(OR CONS COMPILED-FUNCTION))*
;1        (MULTIPLE-VALUE-SETQ (NARGS-REQUIRED NARGS-EXPECTED ) (SI::ARGS-DESC function)))*
    (MULTIPLE-VALUE-SETQ (rest-arg-value rest-arg-p lexpr-call)
                         (sg-rest-arg-value sg frame))
    ;1; Store the individual args.*
    (DOTIMES (i nargs-to-print)
      ;1; These "args" weren't supplied*
      (IF (= i nargs-supplied)
          (PUSH (IF (AND nargs-required (< i nargs-required))
                    "3   --Missing args:--*" "3   --Defaulted args:--*")
                list))
      ;1; Called with too many args*
      (IF (AND nargs-expected (= i nargs-expected))
          (PUSH "3   --Extraneous args:--*" list))
      ;1; Push arg name, value and number*
      (LET ((missing (AND nargs-required
                          (> nargs-required nargs-supplied)
                          (>= i nargs-supplied))))
        (PUSH (LIST (arg-name function i)             ;1 Arg name*
;		1  (OR MISSING (AREF RP (+ FRAME I 1)))*
                    (OR missing (AREF rp (+ argument-index i)))       ;1 Arg Value*
                    (IF (NOT missing) i (LIST :novalue i)))   ;1 Arg Number*
              list)))
    ;1; Print the rest arg if any.*
    (IF (OR rest-arg-p lexpr-call)
        (PUSH (LIST (AND rest-arg-p (local-name function 0))  ;1 Rest Arg Name*
                    rest-arg-value                    ;1 Rest Arg Value*
                    (IF rest-arg-p "3Rest arg*" "3Extraneous rest arg*"))
              list))
    (VALUES (SEND window :setup (LIST 'print-arg-or-local '(arg "3Arg*")
                                      (NREVERSE list)))
            rest-arg-p)))

;1****************
;1 TAC 08-01-89 - this function being redefined by code in WINDOW-DEBUGGER-ENHANCEMENTS*
;1;;REST-ARG-P means that local 0 is in the other window and should not be duplicated*
;1(DEFUN SETUP-LOCALS-WINDOW (WINDOW SG FRAME REST-ARG-P)*

(COMMENT (DEFUN print-special-pdl-range (sg start end &optional (STREAM *standard-output*))
           (DO ((sp (sg-special-pdl sg))
                (i start (+ i 2)))
               ((>= i end))
             (FORMAT stream
                     "3~&~S: ~S~%*"
                     (symbol-from-value-cell-location (AREF sp (1+ i)))
                     (AREF sp i)))))

(DEFUN 4print-arg-or-local* (item type stream ignore)
  (LET (number name value type-name novalue error)
    (IF (STRINGP item)
        (SEND stream :string-out item)
        (PROGN
          (SETQ type-name (SECOND type)
                type (FIRST type)
                name (FIRST item)
                value (SECOND item)
                number (THIRD item))
          (AND (CONSP number)
               (SETQ novalue (FIRST number)
                     number (SECOND number)))
          (COND ((NULL number))
                ((STRINGP number)
                 (SEND stream :string-out number))
                (t (FORMAT stream "3~A ~D*" type-name number)))
          (AND name (COND (number
                           (SEND stream :string-out "3 (*")
                           (SEND stream
                                 :item1 (LIST name number) type
                                 (FUNCTION (lambda (x stream)
                                             (IF (CONSP (CAR x))
                                                 (SEND stream :string-out (FORMAT nil "3~A*" (CAR x)))
                                                 (SEND stream :string-out (SYMBOL-NAME (CAR x)))))))
                           (WRITE-CHAR #\) stream))   ;1(SEND STREAM :TYO #\)))*
                          (t (SEND stream :item1 name type))))
          (COND ((NEQ novalue :novalue)
                 (SEND stream :string-out "3: *")
                 (MULTIPLE-VALUE-SETQ (nil error)
                                      (CATCH-ERROR (SEND stream :item1 value
                                                         :value (FUNCTION tv::print-item-concisely))
                                                   nil))
                 (IF error (SEND stream :string-out "3<<unprintable>>*"))))))))


;1; Support routines for the code window*
(DEFUN 4setup-inspect-window* (inspect-window sg frame inspect-history-window)
  (LET (FUNCTION (label "") code)
    (SETQ function (rp-function-word (sg-regular-pdl sg) frame))
    ;1; Set label to function name for frame*
    ;1; but print nothing for interpreted code*
    (IF (NOT (LISTP function))
        (LET ((name (FUNCTION-NAME function)))
          (SETQ label (COND ((STRINGP name) name)
                            ((SYMBOLP name) (SYMBOL-NAME name))
                            (t (FORMAT nil "3~S*" name))))))
    (SEND inspect-history-window :inspect-object
          (SETQ code (tv::make-stack-frame :stack-group sg
                                          :frame-number frame
                                          :function-name label))
          inspect-window)
    code))




;1; This reads a form or special command (a list in the input stream)*
(DEFUN 4window-command-loop-read* (&optional preemptable) ;1!*
  (DO ((CHAR -1)
       (sexp)
       (flag)
       (typeahead))
      (nil)
    (UNWIND-PROTECT
	(PROGN (COND ((NOT preemptable)
		      (SETQ typeahead (SEND *terminal-io* :old-typeahead))
		      (SEND *terminal-io* :set-old-typeahead nil)))
	       (OR (SEND *terminal-io* :old-typeahead)
		   (SETQ char (tv:read-any *terminal-io*)))	   
	       (COND ((CONSP char)
		      (RETURN char))
		     ((CHAR-EQUAL char #\Help)
		      (window-debugger-help))
		     ((CHAR-EQUAL char #\Page)
		      (SEND *terminal-io* :clear-screen))
		     ((CHAR-EQUAL char #\Rubout))
		     (t
		      (AND char
			   (tv:unread-any char *terminal-io*))
		      (MULTIPLE-VALUE-SETQ (sexp flag)
					   (SEND *terminal-io*
						 :preemptable-read
						 '((:full-rubout :full-rubout))
						 (FUNCTION read-for-top-level)))
		      (AND (EQ flag :mouse-char)
			   (RETURN sexp))
		      (OR (EQ flag :full-rubout)
			  (RETURN nil sexp)))))
      (OR preemptable (SEND *terminal-io* :set-old-typeahead typeahead)))))

;1; This gets an object to return or something*
(DEFUN 4window-read-object* (keyword &rest format-string-and-args)
  (LET (SPECIAL sexp ask-p old-si-types)
    (COND
      ((EQ keyword :eval-read)
       (SETQ old-si-types (SEND *window-debugger* :sensitive-item-types))
       (UNWIND-PROTECT
           (PROG nil
                 (SEND *window-debugger* :set-sensitive-item-types '(:value :function stack-frame))
              retry
                 (APPLY 'FORMAT t format-string-and-args)
                 (MULTIPLE-VALUE-SETQ (SPECIAL sexp) (window-command-loop-read))
                 (COND ((CONSP special)
                        (IF (SEND *window-debugger* :inspect-window-p (THIRD special))
                            (SETQ sexp (tv::inspect-real-value special)
                                  ask-p t)
                            (LET ((type (FIRST special)))
                              (COND ((EQ type :value)
                                     (SETQ sexp (SECOND special)
                                           ask-p t))
                                    ((AND (EQ type :menu)
                                          (MEMBER (SETQ sexp (SEND (FOURTH special) :execute (SECOND special)))
                                                  '(t nil-value)
                                                  :test (FUNCTION eq)))
                                     (SETQ sexp  (EQ sexp t)
                                           ask-p nil))
                                    (t (BEEP) (GO retry))))))
                       (t (SETQ ask-p (si::constantp sexp) ;1; *(si:trivial-form-p sexp)1 * ;1 TAC 09-02-89*
                                sexp (LET ((otoc (sg-flags-trap-on-call *error-sg*)))
                                       (SETF (sg-flags-trap-on-call *error-sg*) 0)
                                       (PROG1 (CAR (sg-eval *error-sg* sexp t))
                                              (SETF (sg-flags-trap-on-call *error-sg*) otoc))))))
                 (AND ask-p (COND ((NOT (window-y-or-n-p "3The object is ~S, ok? (Y or N) *" sexp))     ;1.*
                                   (TERPRI)
                                   (GO retry))))
                 (RETURN sexp))
         (SEND *window-debugger* :set-sensitive-item-types old-si-types)))
      ((EQUAL keyword '(:fquery)) (APPLY 'window-y-or-n-p format-string-and-args))
      (t (APPLY 'PROMPT-AND-READ keyword format-string-and-args)))))

(DEFUN 4window-y-or-n-p* (STRING &rest format-args)
  (APPLY (FUNCTION format) t string format-args)
  (DO ((ch))
      (nil)
    (SETQ ch (tv:read-any *standard-input*))
    (AND (CONSP ch)
         (EQ (FIRST ch) :menu)
         (MEMBER (SETQ ch (SEND (FOURTH ch) :execute (SECOND ch)))
                 '(t nil-value)
                 :test
                 (FUNCTION eq))
         (SETQ ch (IF (EQ ch t) #\Y #\N)))
    (SETQ ch (INT-CHAR ch))		   ;1.*
    (COND ((MEMBER ch '(#\Y #\y #\Space) :test (FUNCTION eq))
           (PRINC "3yes*")
           (RETURN t)))
    (COND ((MEMBER ch '(#\N #\n #\Rubout) :test (FUNCTION eq))
           (PRINC "3no*")
           (RETURN nil)))
    (PRINC "3(Y or N)*")))


(DEFUN 4window-read-function* (action &optional allow-t return-stack-frames)
  (LET (SPECIAL function)
    (FORMAT t
            "3~&Type or mouse a function ~A (NIL aborts~:[, T ~A nothing~]):~%*"
            action
            (NOT allow-t)
            action)
    (MULTIPLE-VALUE-SETQ (SPECIAL function) (window-command-loop-read))
    (AND special (SETQ function (IF (SEND *window-debugger* :inspect-window-p (THIRD special))
                                    (tv::inspect-real-value special)
                                    (CASE (FIRST special)
                                      (:menu  (AND (EQ (SEND (FOURTH special)
                                                             :execute
                                                             (SECOND special))
                                                       t)
                                                   allow-t))
                                      (stack-frame  (IF
                                                      return-stack-frames
                                                      special
                                                      (stack-frame-function-and-args
                                                        *error-sg*
                                                        (SECOND special))))
                                      (:line-area  (IF
                                                     return-stack-frames
                                                     (LIST 'stack-frame (SECOND special))
                                                     (stack-frame-function-and-args
                                                       *error-sg*
                                                       (SECOND special))))
                                      ((SPECIAL arg local)  (FIRST (SECOND special)))
                                      ((:value :function special)  (SECOND special))))))
    (WHEN (CLOSUREP function)
      (SETQ function (CLOSURE-FUNCTION function)))
    (COND ((TYPEP function 'instance)
           (SETQ special (window-read-thing "3~&Type or mouse a message name for ~S:~%*" function))
           (LET ((handler (GET-HANDLER-FOR function special)))
             (OR handler (FORMAT t "3~&~S does not handle the ~S message.~%*" function special))
             (SETQ function handler)))
          ((NULL function)
           (FORMAT t "3~&Aborted.~%*")))
    function))

;1----------------------------------------------------------------------------------------------*
;1(LET ((compiler:compile-encapsulations-flag t))*
;1     (ADVISE eh:window-read-thing :around :make-sure-not-inspection-data*
;	1     nil*
;1       (LET ((results (MULTIPLE-VALUE-LIST :do-it)))*
;	1    (IF (TYPEP (FIRST results) 'tv:inspection-data)*
;		1(VALUES-LIST (CONS (OR (SEND (FIRST results) :send-if-handles*
;					1     :middle-button-result)*
;				1       (SEND (FIRST results) :send-if-handles*
;					1     :aux-data)*
;				1       (SEND (FIRST results) :data))*
;				1   (REST results)))*
;		1(VALUES-LIST results)))))*
;1----------------------------------------------------------------------------------------------*

(DEFUN 4window-read-thing* (prompt &rest format-args)
  (LET ((results 
	  (MULTIPLE-VALUE-LIST
	    ;1; --- original body of code represented by :do-it in advice commented above ---*
	    (LET (SPECIAL thing)
	      (APPLY (FUNCTION format) t prompt format-args)
	      (MULTIPLE-VALUE-SETQ (SPECIAL thing) (window-command-loop-read))
	      (SETQ thing (IF special
			      (IF (SEND *window-debugger* :inspect-window-p (THIRD special))
				  (tv::inspect-real-value special)
				  (CASE (FIRST special)
				    (:menu  (EQ (SEND (FOURTH special) :execute (SECOND special)) t))
				    (stack-frame  (list-stack-frame-function-and-args *error-sg*
										      (SECOND special)))
				    (:line-area  (list-stack-frame-function-and-args *error-sg*
										     (SECOND special)))
				    ((SPECIAL arg local)  (FIRST (SECOND special)))
				    ((:value :function special)  (SECOND special))))
			      (CAR (sg-eval-in-frame *error-sg* thing *current-frame* t)))) ;1; take frame into consideration*
	      (IF (NULL thing) (FORMAT t "3~&Aborted.~%*"))
	      thing))))
              ;1; ---------------------------------------------------------------------*
    (IF (TYPEP (FIRST results) 'tv::inspection-data)
	(VALUES-LIST (CONS (OR (SEND (FIRST results) :send-if-handles
				     :middle-button-result)
			       (SEND (FIRST results) :send-if-handles
				     :aux-data)
			       (SEND (FIRST results) :data))
			   (REST results)))
	(VALUES-LIST results))))

(DEFUN 4list-stack-frame-function-and-args* (sg frame)
  (LET (LIST)
    (MULTIPLE-VALUE-BIND (FUNCTION args-start args-end) 
        (stack-frame-function-and-args sg frame)
      (PUSH (FUNCTION-NAME function) list)
      (DO ((i args-start (1+ i))
           (l 1 (1+ l))
           (rp (sg-regular-pdl sg)))
          ((>= i args-end)
           (NREVERSE list))
        (PUSH (AREF rp i) list)))))


;1--------------------------*
;1; The commands*
;1--------------------------*

(DEFUN 4comw-proceed* (*error-sg* *error-object* &rest ignore)
   (LET (proceed-types proceed-type 
        (resume-handlers (SYMEVAL-IN-STACK-GROUP 'condition-resume-handlers
                                                 *error-sg*)))
    (error-handler-must-be-running)
    (SETQ proceed-types (SEND *error-object*
                              :user-proceed-types
                              (sg-condition-proceed-types *error-sg* *error-object*)))
    (IF
      (NOT proceed-types)
      (FORMAT t "3There is no way to proceed from this error.~%*")
      (WHEN
        (SETQ
          proceed-type
          (w:menu-choose 
            (APPEND (MAPCAR (FUNCTION (lambda (proceed-type)
                                        (LIST (format:output nil
                                                (SEND *error-object*
                                                      :document-proceed-type
                                                      proceed-type
                                                      *standard-output*
                                                      resume-handlers))
                                              :value
                                              proceed-type
                                              :documentation
                                              "3Select this proceed type.*")))
                            proceed-types)
                    (MAPCAR (FUNCTION (lambda (special-command)
                                        (LIST (format:output nil
                                                (SEND *error-object*
                                                      :document-special-command
                                                      special-command
                                                      *standard-output*))
                                              :value
                                              special-command
                                              :documentation
                                              "3Select this command.*")))
                            *special-commands*))
	 :label  "3Which type of proceed?*"))		
	(SEND *error-object*
              :proceed-asking-user
              proceed-type
              'proceed-error-sg
              'window-read-object)))
    nil))

(DEFUN 4comw-what-error* (sg *error-object*)
  (SEND *error-object* :print-error-message sg t *standard-output*))

(DEFUN 4comw-describe* (IGNORE ignore)
  (LET ((thing (window-read-thing "3~&Type or mouse something to describe:~%*")))
    (IF thing (DESCRIBE thing))))

(DEFUN 4comw-inspect* (IGNORE ignore)
  (LET ((thing (window-read-thing "3~&Type or mouse something to inspect:~%*")))
    (IF thing (SEND *window-debugger* :inspect-object thing))))

;1; 7/13/88 clm for may - Must look at BOTH values catch-error returns.*
(DEFUN 4comw-arglist* (sg ignore)
  (LET ((FUNCTION (window-read-function "3for arglist*" nil t)))
    (IF function (COND ((AND (SYMBOLP function)
                             (NOT (FBOUNDP function)))
                        (FORMAT t "3~&~S is not defined.*" function))
                       ((AND (CONSP function)
                             (EQ (FIRST function) 'stack-frame))
                        (print-frame-arglist sg (SECOND function)))
                       (t
                        (SETQ function (FUNCTION-NAME function))
                        (MULTIPLE-VALUE-BIND (val error)
                            (CATCH-ERROR (ARGLIST function) nil)
                          ;1;(IF ERROR*
			  ;1; checking second value for an error is not enough, first must be nil, too *
                          (IF (AND error (NULL val)) ;1; did catch-error get an error ?*
                              (FORMAT t "3~&~S is not a function.*" function)
                              (FORMAT t "3~&~S: ~:A~%*" function val))))))))

(DEFUN 4print-frame-arglist* (sg frame)
  (LET ((str1 (MAKE-ARRAY 50. :element-type 'string-char :leader-list '(0)))
        (str2 (MAKE-ARRAY 50. :element-type 'string-char :leader-list '(0)))
        function args-start args-end)
    (VECTOR-PUSH-EXTEND (si::pttbl-open-paren *readtable*) str1)
    (MULTIPLE-VALUE-SETQ (FUNCTION args-start args-end)
                         (stack-frame-function-and-args sg frame))
    (FORMAT str1 "3~S*" (FUNCTION-NAME function))
    (VECTOR-PUSH-EXTEND (si::pttbl-space *readtable*) str1)
    (COPY-ARRAY-CONTENTS-AND-LEADER str1 str2)
    (DO ((ARGLIST (ARGLIST function) (CDR arglist))
         (rp (sg-regular-pdl sg))
         (i args-start)
         (flag nil t))
        ((AND (NULL arglist) (>= i args-end)))
      (LET ((i1 (IF flag 1 0)) (i2 (IF flag 1 0)))
        (LET ((len1 (ARRAY-LEADER str1 0))
              (len2 (ARRAY-LEADER str2 0)))
          (COND ((> len1 len2)
                 (SETQ i2 (1+ (- len1 len2))))
                ((< len1 len2)
                 (SETQ i1 (1+ (- len2 len1))))))
        (COND (ARGLIST
               (DOTIMES (i i1) (VECTOR-PUSH-EXTEND #\Sp str1))
               (FORMAT str1 "3~S*" (CAR arglist))
               (AND (MEMBER (CAR arglist) '(&optional &rest) :test (FUNCTION eq))
                    (SETQ flag '&mumble))))
        (COND ((< i args-end)
               (DOTIMES (i i2) (VECTOR-PUSH-EXTEND #\Sp str2))
               (COND ((NEQ flag '&mumble)
                      (FORMAT str2 "3~S*" (AREF rp i))
                      (SETQ i (1+ i))))))))
    (VECTOR-PUSH-EXTEND (si::pttbl-close-paren *readtable*) str2)
    (VECTOR-PUSH-EXTEND (si::pttbl-close-paren *readtable*) str1)
    (SEND *standard-output* :fresh-line)
    (SEND *standard-output* :line-out str1)
    (SEND *standard-output* :line-out str2)))

(DEFUN 4stack-frame-into-list* (frame sg &aux list function args-start args-end)
  (MULTIPLE-VALUE-SETQ (FUNCTION args-start args-end)
    (stack-frame-function-and-args sg frame))
  (SETQ list (CONS (FUNCTION-NAME function) nil))
  (DO ((i args-start (1+ i))
       (rp (sg-regular-pdl sg)))
      ((>= i args-end))
    (PUSH (AREF rp i) list))
  (NREVERSE list))

(DEFUN 4comw-set-arg* (sg ignore &aux char)
  (FORMAT t "3~&Mouse an argument or local to modify:~%*")
  (LET ((old-si-types (SEND *window-debugger* :sensitive-item-types)))
    (SEND *window-debugger* :set-sensitive-item-types '(arg local))
    (UNWIND-PROTECT
      (SETQ char (SEND *standard-input* :any-tyi))
      (SEND *window-debugger* :set-sensitive-item-types old-si-types)))
  (IF (NOT (AND (CONSP char) (MEMBER (CAR char) '(local arg) :test (FUNCTION eq)) (CONSP (SECOND char))))
      (FORMAT t "3~&That is not an argument or local~%*")
    (LET ((idx (CADADR char)))
      (IF (NOT (NUMBERP idx))
	  (FORMAT t "3~&Cannot set rest arg.*")
	(LET ((new-obj (read-object :eval-read
				    (FORMAT nil "3Value to substitute for ~A: *"
					    (CAADR char)))))
	  (LET ((rp (sg-regular-pdl sg)))
            (SETF (AREF rp (+ idx (IF (EQ (CAR char) 'arg) 
			     (sys:rp-argument-offset sg rp *current-frame*)
			   (sys:rp-local-offset sg rp *current-frame*)))) new-obj)))))
    (SEND *window-debugger* :setup-frame sg *current-frame* t t)))

(COMPILE-FLAVOR-METHODS debugger-who-line-mixin
                        debugger-frame
                        debugger-lisp-listener-pane
                        debugger-text-scroll-pane
                        gray-debugger-text-scroll-pane
                        gray-debugger-thermometer-text-scroll-pane
                        stack-scroll-pane
                        debugger-history-pane
                        debugger-menu-pane
                        debugger-inspect-pane)


(DEFWINDOW-RESOURCE 4debugger-frame*
                    nil
  :make-window
  (debugger-frame)
  :reusable-when
  :deactivated)
  ;1 :initial-copies 0)

